#include <stdio.h>
#include <string.h>
#include "fat.h"
#include "standalone.h"

//#define EXTEND_DIRECTORY

#define DEBUG_LEVEL 0

#define MINFILESECTORS  0x00040000/*256k-sectors, 44mins of 24kHz mono wav*/
#define MAXFILESECTORS  0x00800000/*2^23 sectors = 2^32 bytes*/
//1h09m of 24kHz mono WAV, 1h23m 320kbps mp3, 2h47m 160kbps mp3
//#define MAXFILESECTORS  0x60000

__y struct MMC mmc;

s_int16 FsGetFreeSectors(void *private, u_int32 sector, u_int32 numSecs) {
    if (mmc.freeSize < numSecs) {
	mmc.freeSize = numSecs;
	mmc.freeStart = sector;
	if (mmc.freeSize >= MAXFILESECTORS) {
#if DEBUG_LEVEL > 0
	    puts("Got enough!");
#endif
	    return 1; /*done*/
	}
    }
#if DEBUG_LEVEL > 1
    puthex(sector>>16);
    puthex(sector);
    putchar(' ');
    puthex(numSecs>>16);
    puthex(numSecs);
    puts("=sec,num");
#endif
    return 0;
}


#define FFDE_OK          0
#define FFDE_FAT12       1
#define FFDE_NOSPACE     2
#define FFDE_NAMEINVALID 3

/*
  Does not support FAT12.
  Only handles root directory.
  Only extends directory with FAT32.
 */

auto s_int16 FatFindDirEntry(const u_int16 *packedName /*8.3 name*/) { /*224*/
    register __i1 __y struct FRAGMENT *curFragment;
    __y struct FRAGMENT * __y nextFragment;
    register __b u_int32 currentSector;
    register __i3 int i;

    /* Start at the start of root directory. */
    if (fatInfo.IS_FAT_32) {
	nextFragment = FragmentList(&fragments[0], 2);
    } else if (fatInfo.FilSysType != 0x3231) {
	fragments[0].start = fatInfo.rootStart | LAST_FRAGMENT;
	fragments[0].size  = ((s_int16)fatInfo.BPB_RootEntCnt >> 4);
	nextFragment = &fragments[1];
    } else {
	return FFDE_FAT12;	/*FAT12 not supported*/
    }
    //return FatHandleDir(curFragment, nextFragment);

 again:
    curFragment = &fragments[0];
    /* fatInfo.parentDir = */
    currentSector = curFragment->start & 0x7fffffffUL;
    mmc.dirLine = -1;
    i = 0;
    goto getfirst;
    while (1) {
	register __d1 u_int16 fn = GetByte(i+0); /*first char of filename*/
	if (fn == 0xe5 || fn == 0) {/* 0xe5 / 0x00 deleted or new entry */
	    /* Found! */
	    if (mmc.dirLine < 0) {
		mmc.dirLine = i;
		mmc.dirBlock = currentSector;
	    }
	    /* End of directory, so we are done. */
	    if (fn == 0)
		return FFDE_OK;
	} else {
	    if ((GetByte(i+11/*Attr*/) & 0xde) == 0) {
#if DEBUG_LEVEL > 2
		puts(" FILE");
#endif
		/* Regular file -- check filename */

		/* Only check 8.0, if these match, it is not valid.
		   This only restricts the selection of filename,
		   it does not create duplicates.
		   We can then later have any suffix we want when
		   we actually create the entry, i.e. .OGG, .MP3 or .WAV .
		*/
		if (!memcmp(stream_buffer+i/2, packedName, 8/2))
		    return FFDE_NAMEINVALID;

		/* remember the highest used cluster */
		{
		    u_int32 cluster =
			((u_int32)GetWord(i+20) << 16) + GetWord(i+26);
		    if (mmc.usedTopCluster < cluster)
			mmc.usedTopCluster = cluster;
		}
	    }
	}
	i = (i + 32) & 511;
	if (i == 0) {
	    /* if end of directory block, get the next one */
	    currentSector++;
	    if (currentSector >=
		(curFragment->start & 0x7fffffffUL) + curFragment->size) {
		if ((s_int32)curFragment->start < 0) {
		    if (mmc.dirLine < 0) {
#ifdef EXTEND_DIRECTORY
			/* Increase the directory size -- for FAT32 only! */
			if (fatInfo.IS_FAT_32) {
			    mmc.dirBlock = mmc.freeStart;
			    mmc.dirLine = 0;
			    mmc.freeStart += fatInfo.fatSectorsPerCluster;
			    mmc.freeSize  -= fatInfo.fatSectorsPerCluster;

#if DEBUG_LEVEL > 1
			    puthex(mmc.dirBlock>>16);
			    puthex(mmc.dirBlock);
			    puts("=new dirblock");
#endif
			    /*Allocate new cluster for directory. */
			    FsFatAllocate2(mmc.dirBlock,
					   1 /*fatSectorsPerCluster*/,
					   0x0fffffffUL,
					   0);
			    /*Fix the cluster chain link. */
			    FsFatAllocate2(currentSector-1,
					   1 /*fatSectorsPerCluster*/,
					   (mmc.dirBlock-fatInfo.dataStart)
					   / fatInfo.fatSectorsPerCluster,
					   0);
			    /*Clear the new dirblocks */
#if 0
			    memset(stream_buffer, 0, 512/2);
			    for (i=0; i<fatInfo.fatSectorsPerCluster; i++){
				FsMapMmcWrite(map, mmc.dirBlock+(u_int16)i,
					      1, stream_buffer);
			    }
#else
			    currentSector = mmc.dirBlock;
			    memset(stream_buffer, 0, 512/2);
			    for (i=0; i<fatInfo.fatSectorsPerCluster; i++){
				FsMapMmcWrite(map, currentSector,
					      1, stream_buffer);
				currentSector++;
			    }
#endif
			} else
#endif
			{
#if DEBUG_LEVEL > 0
			    puts("Dir FULL!");
#endif
			    return FFDE_NOSPACE;
			}
		    }
		    return FFDE_OK;
		}
		curFragment++;
		currentSector = curFragment->start & 0x7fffffffUL;
	    }
#if 0 && defined(USE_DEBUG)
	    puthex(currentSector);
#endif
	getfirst:
	    ReadDiskSectorTo(fatInfo.currentSector = currentSector,
			     stream_buffer);
	}
    }
}

void FatPrepareForSaving(void) { /*83*/
    u_int16 name[12/2];

#if DEBUG_LEVEL > 0
    puts("Preparing");
#endif
    mmc.dirLine = -1; /* no space for entry yet */
    mmc.fileSize = 0;
    if (mmc.fileName[0] != (('V'<<8) | 'O')) {
	memcpyXY(mmc.fileName, "\pVOICE_00WAV", sizeof(mmc.fileName));
    }

#if DEBUG_LEVEL > 0
    puts("Iter");
#endif
    /* Must find free area first to be able to extend directory! */

    /* If there is some leftover free area, just try to extend it! */
    if (mmc.freeSize && mmc.freeSize < MAXFILESECTORS) {
	mmc.usedTopCluster = (mmc.freeStart - fatInfo.dataStart) / fatInfo.fatSectorsPerCluster;
    }
    mmc.freeSize = 0;
    FatIterateOverFreeSectorsLimited(FsGetFreeSectors, NULL, 2*MAXFILESECTORS);
    /* If free area smaller than we would at least want to get, and
       we started search from some high start cluster, start  over. */
    if (mmc.freeSize < MINFILESECTORS && mmc.usedTopCluster) {
	mmc.usedTopCluster = 0;
	mmc.freeSize = 0;
	FatIterateOverFreeSectorsLimited(FsGetFreeSectors, NULL, 2*MAXFILESECTORS);
    }

#if DEBUG_LEVEL > 0
    puts("Find ");
    puthex(mmc.freeStart>>16);
    puthex(mmc.freeStart);
    puts("=St");
    puthex(mmc.freeSize>>16);
    puthex(mmc.freeSize);
    puts("=Sz");
    //puthex((mmc.freeStart - fatInfo.dataStart) / fatInfo.fatSectorsPerCluster);
    //puts("=first data cluster");
#endif
    goto try1;
    do {
	if ((++mmc.fileName[3] & 0xff) > '9') {
	    if (
//		((mmc.fileName[3] += 0x100-10) & 0xff00) > ('9'<<8)
		(mmc.fileName[3] += 0x100-10) > (('9'<<8)+0xff)
		) {
		mmc.fileName[3] = 0x3030; /* "00" */
		/* avoid '[' '\' ']' and '@' */
		if ((++mmc.fileName[2] & 0xff) > 'Z')
		    mmc.fileName[2] = (('E'<<8) + 'A');
	    }
	}
    try1:
	memcpyYX(name, mmc.fileName, sizeof(name));
#if DEBUG_LEVEL > 1
	putchar(name[0]>>8);
	putchar(name[0]);
	putchar(name[1]>>8);
	putchar(name[1]);
	putchar(name[2]>>8);
	putchar(name[2]);
	putchar(name[3]>>8);
	putchar(name[3]);
	putchar('.');
	putchar(name[4]>>8);
	putchar(name[4]);
	putchar(name[5]>>8);
	puts("-Try");
#endif
    } while (FatFindDirEntry(name) == FFDE_NAMEINVALID);
    if (mmc.dirLine >= 0) {
#if DEBUG_LEVEL > 0
	puthex(mmc.dirBlock>>16);
	puthex(mmc.dirBlock);
	putchar(' ');
	puthex(mmc.dirLine);
	puts(" sec,off");
#endif
    } else {
#if DEBUG_LEVEL > 0
	puts("-N/A");
#endif
    }
}
