#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fat.h"
#include "standalone.h"

#define DEBUG_LEVEL 0


#define YEAR 2011
#define MONTH 9
#define DAY   19
#define HOURS   12
#define MINUTES 34
#define SECONDS 56
u_int16	created[3] = {
#if 0
    ((YEAR-1980)*2 + (MONTH/8))*256 + ((MONTH&7)*32 + DAY), /*0x3a69*/
    (HOURS<<11) | (MINUTES<<5) | (SECONDS/2), /* in 2-second resolution */
    (SECONDS&1)*100*256   /* 0..199ms gives [0..2) seconds */
#else
    0, 0, 0
#endif
};

void FsFatMakeFile(void) {
    register u_int32 cluster =
	(mmc.freeStart - fatInfo.dataStart) / fatInfo.fatSectorsPerCluster;

    if (mmc.dirLine < 0)
	return;

    /* allocate sectors -- modifies freeStart and freeSize! */
    FsFatAllocate2(mmc.freeStart, (mmc.fileSize + 511) / 512,
		   0x0fffffffUL, 0);

    ReadDiskSectorTo(fatInfo.currentSector = mmc.dirBlock, stream_buffer);

/*4B4F4546494C45315241570000C62E000000700033000000FFFFDA09FFFFFFFF
  name -----------------
  attr 11               --
  ntres 12                --
  crt time 13 14 16         tttimedate
  last access date 18                 ----
  cluster hi 20                           ----
  write time 22 24                            timedate
  cluster low 26                                      ----
  filesize 28                                             --------

Byte	Length 	Description
0x00 	8 	DOS file name (padded with spaces)

  The first byte can have the following special values:
  0x00 	Entry is available and no subsequent entry is in use
  0x05 	Initial character is actually 0xE5
  0x2E 	'Dot' entry; either '.' or '..'
  0xE5 	Entry has been previously erased and is available. File undelete utilities must replace this character with a regular character as part of the undeletion process.

0x08 	3 	DOS file extension (padded with spaces)
0x0b 	1 	File Attributes
  Bit 	Mask 	Description
  0 	0x01 	Read Only
  1 	0x02 	Hidden
  2 	0x04 	System
  6 	0x40 	Device (internal use only, never found on disk)
  7 	0x80 	Unused
  An attribute value of 0x0F is used to designate a long file name entry.

0x0c 	1 	Reserved; two bits are used by NT and later versions to encode case information (see below); otherwise 0[30]
0x0d 	1 	Create time, fine resolution: 10ms units, values from 0 to 199.
0x0e 	2 	Create time. The hour, minute and second are encoded according to the following bitmap:
  Bits 	Description
  15-11	Hours (0-23)
  10-5 	Minutes (0-59)
  4-0 	Seconds/2 (0-29)
  Note that the seconds is recorded only to a 2 second resolution. Finer resolution for file creation is found at offset 0x0d.

0x10 	2 	Create date. The year, month and day are encoded according to the following bitmap:
  Bits 	Description
  15-9 	Year (0 = 1980, 127 = 2107)
  8-5 	Month (1 = January, 12 = December)
  4-0 	Day (1 - 31)

0x12 	2 	Last access date; see offset 0x10 for description.
0x14 	2 	EA-Index (used by OS/2 and NT) in FAT12 and FAT16, High 2 bytes of first cluster number in FAT32
0x16 	2 	Last modified time; see offset 0x0e for description.
0x18 	2 	Last modified date; see offset 0x10 for description.
0x1a 	2 	First cluster in FAT12 and FAT16. Low 2 bytes of first cluster in FAT32. Entries with the Volume Label flag, subdirectory ".." pointing to root, and empty files with size 0 should have first cluster 0.
0x1c 	4 	File size in bytes. Entries with the Volume Label or Subdirectory flag set should have a size of 0.
 */
    {
	register u_int16 *p = stream_buffer + mmc.dirLine/2;
	memset(p, 0, 32/2);
	memcpyYX(p, mmc.fileName, 12/2);
	p += 10/2;
	//*p |= attrib;
	p += (12-10)/2;
	*p = (*p & 0xff00) | (SwapWord(created[2]) & 0xff); /* 0..199 ms */
	p += (14-12)/2;
	*p = SwapWord(created[1]); /*create time*/
	p += (16-14)/2;
	*p = SwapWord(created[0]); /*create date*/
	p += (20-16)/2;
	*p = SwapWord(cluster>>16);/*Cluster HI 20*/
	p += (22-20)/2;
	*p = SwapWord(created[1]); /*last modified time*/
	p += (24-22)/2;
	*p = SwapWord(created[0]); /*last modified date*/
	p += (26-24)/2;
	*p = SwapWord(cluster); /*Cluster LO 26*/
	p += (28-26)/2;
	*p++ = SwapWord(mmc.fileSize); /*filesize 28..31*/
	*p = SwapWord(mmc.fileSize>>16);
    }
    MmcWrite(mmc.dirBlock, stream_buffer);
#if DEBUG_LEVEL > 1
    puts("New dir block");
    FsPrintSector(mmc.dirBlock);
#endif
}
