#include <string.h>
#include "fat.h"
#include "standalone.h"

/*
  Iterates only upto last cluster, not upto total size.
  Uses cluster count to determine FAT12 (InitFileSystem()).
 */
#if 1
#define USE_MULTIPLE_BLOCK_READ
void FATINFO_SIZE_IS_NOT_SIZEOF_FATINFO(void);

s_int16 FatIterateOverFreeSectorsLimited(freeSectorCallback callBackFunction,
					 void *private,
					 u_int32 minSectors) {
    s_int32 fatCluster = 0;
    __y u_int16 offset = 0;
    __y u_int32 start = 0;
    register __reg_d u_int32 size = 0;
    int c;

    if (FATINFO_SIZE != sizeof(fatInfo)) {
	FATINFO_SIZE_IS_NOT_SIZEOF_FATINFO();
    }

    /* If FAT12, nothing can be done.. */
    if (fatInfo.FilSysType == 0x3231)
      return 0;

    start = fatInfo.fatStart;
    if (mmc.usedTopCluster) {
#if 0
	puthex(mmc.usedTopCluster>>16);
	puthex(mmc.usedTopCluster);
	puts("=topclus");
#endif
	fatCluster = mmc.usedTopCluster;
	if (fatInfo.IS_FAT_32) {
	    offset = ((u_int16)fatCluster & 0x7F) << 2;
	    start = (fatCluster >> 7) + fatInfo.fatStart;
	} else {
	    offset = ((u_int16)fatCluster & 0xff) << 1;
	    start = (fatCluster >> 8) + fatInfo.fatStart;
	}
    }


#ifdef USE_MULTIPLE_BLOCK_READ
    c = MmcCommand(MMC_READ_MULTIPLE_BLOCK|0x40,(start<<hcShift));
#endif /*USE_MULTIPLE_BLOCK_READ*/
    goto read;
    while (1) {
	{
	    register u_int32 t;
	    if (fatInfo.IS_FAT_32) {
		t = GetLong(offset) & 0x0fffffffUL;
		offset += 4;
	    } else {
		t = GetWord(offset);
		offset += 2;
	    }
#if 0
	    printf("%08ld %08ld %03d t %08lx\n",
		   fatCluster, fatInfo.currentSector, offset, t);
#endif
	    if (t == 0 /* free */) {
		if (size == 0) {
		    start = fatCluster * fatInfo.fatSectorsPerCluster +
			fatInfo.dataStart;
		}
		size += fatInfo.fatSectorsPerCluster;
	    } else if (size) {
	        if (callBackFunction(private, start, size)) {
#ifdef USE_MULTIPLE_BLOCK_READ
		    goto ret;
#endif
		    return 1;
		}
		size = 0;
	    }
	}
	++fatCluster;
	/*TODO: calculate the actual number of clusters and stop there! */
	if (size >= minSectors ||
#if 0
	    fatCluster * fatInfo.fatSectorsPerCluster
	    + fatInfo.dataStart + 1 >= fatInfo.totSize
#else
	    fatCluster >= fatInfo.numClusters
#endif
	    ) {
	    if (size) {
	        if (callBackFunction(private, start, size)) {
#ifdef USE_MULTIPLE_BLOCK_READ
		    goto ret;
#endif
		    return 1;
		}
	    }
#ifdef USE_MULTIPLE_BLOCK_READ
	    goto ret;
#endif
	    return 0;
	}
	offset &= 511;
	if (offset != 0)
	    continue;
    read:
	/* If FAT page is not already in memory, load it. */
#ifdef USE_MULTIPLE_BLOCK_READ
	{
	    register u_int16 c;
	    register u_int16 t = 65535;
	    register u_int16 *data = stream_buffer;
	    do {
		c = SpiSendReceiveMmc(0xff00,8);
	    } while (c == 0xff /*&& --t != 0*/);

	    if (c != 0xfe) {
		memset(data, 0, 256);
		SpiSendClocks();
		break;//return 0;
	    }
	    for (c=0; c<256; c++) {
		*data++ = SpiSendReceiveMmc(0xFFFF, 16);
	    }
	    SpiSendReceiveMmc(0xFFFF, 16);	/* Discard CRC */
	}
#else
	if (fatInfo.IS_FAT_32) {
	    offset = ((u_int16)fatCluster & 0x7F) << 2;
	    ReadDiskSectorTo(fatInfo.currentSector =
			     (fatCluster >> 7) + fatInfo.fatStart,
			     stream_buffer);
	} else {
	    offset = ((u_int16)fatCluster & 0xff) << 1;
	    ReadDiskSectorTo(fatInfo.currentSector =
			     (fatCluster >> 8) + fatInfo.fatStart,
			     stream_buffer);
	}
#endif
    }
ret:
#ifdef USE_MULTIPLE_BLOCK_READ
    c = MmcCommand(MMC_STOP_TRANSMISSION|0x40, 0);
    do {
	c = SpiSendReceiveMmc(0xff00, 8);
	/*TODO: timeout?*/
    } while (c != 0xff);
    SpiSendClocks(); /*XCS high*/
    fatInfo.currentSector = -1;
#endif/*USE_MULTIPLE_READ*/
    return 0;
}
#endif

#if 0
s_int16 FatIterateOverFreeSectors(freeSectorCallback callBackFunction,
				  void *private) {
    s_int32 fatCluster = 0;
    __y u_int16 offset;
    __y u_int32 start = 0;
    register __reg_d u_int32 size = 0;

    if (FATINFO_SIZE != sizeof(fatInfo)) {
	FATINFO_SIZE_IS_NOT_SIZEOF_FATINFO(100);
    }

    /* If FAT12, nothing can be done.. */
    if (!fatInfo.IS_FAT_32 && fatInfo.FilSysType == 0x3231)
      return 0;

    goto read;
    while (1) {
	{
	    register u_int32 t;
	    if (fatInfo.IS_FAT_32) {
		t = GetLong(offset) & 0x0fffffffUL;
		offset += 4;
	    } else {
		t = GetWord(offset);
		offset += 2;
	    }
#if 0
	    printf("%08ld %08ld %03d t %08lx\n",
		   fatCluster, fatInfo.currentSector, offset, t);
#endif
	    if (t == 0 /* free */) {
		if (size == 0) {
		    start = fatCluster * fatInfo.fatSectorsPerCluster +
			fatInfo.dataStart;
		}
		size += fatInfo.fatSectorsPerCluster;
	    } else if (size) {
	        if (callBackFunction(private, start, size))
		    return 1;
		size = 0;
	    }
	}
	++fatCluster;
	/*TODO: calculate the actual number of clusters and stop there! */
	if (fatCluster * fatInfo.fatSectorsPerCluster
	    + fatInfo.dataStart + 1 >= fatInfo.totSize) {
	    if (size) {
	        if (callBackFunction(private, start, size))
		    return 1;
	    }
	    return 0;
	}
	offset &= 511;
	if (offset != 0)
	    continue;
    read:
	/* If FAT page is not already in memory, load it. */
	if (fatInfo.IS_FAT_32) {
	    offset = ((u_int16)fatCluster & 0x7F) << 2;
	    ReadDiskSectorTo(fatInfo.currentSector =
			     (fatCluster >> 7) + fatInfo.fatStart,
			     stream_buffer);
	} else {
	    offset = ((u_int16)fatCluster & 0xff) << 1;
	    ReadDiskSector(fatInfo.currentSector =
			   (fatCluster >> 8) + fatInfo.fatStart,
			   stream_buffer);
	}
    }
}
#endif
