#ifndef STANDALONE_H
#define STANDALONE_H
#define STANDALONE  /*defined for vs1053 header files*/

/* Now support High-Capacity SD (SDHC) cards by default! */

#define COMPAT_KEYS  /**< Read the old 3-button interface of vs10xx prototyping board. */

#define SHUFFLE_PLAY /**< shuffle play instead of random */
#ifndef RECORDER
#define SKIP_ID3V2   /**< quickly skip ID3v2 tags */
#endif

#define FAT12_SUPPORT /**< Support FAT12 with subdirectories and fragments (in player)! Supports unfragmented root directory even without the define.*/


//#define NO_WMA /**< reject WMA files */
//#define NO_AAC /**< reject AAC files */
//#define NO_MP3 /**< do not play mp3 */

//#define HDATCHECK 800 /**< give up after 800/2=400kB ~ 3-6sec */
#define KEEP_DRIVERS_OFF /**< .. until MMC located */
#define WITH_SUBDIRECTORIES /**< support subdirectories */

//#define ENABLE_I2S /**< Enable I2S output*/
//#define ENABLE_HIGHREF /**< Use 1.6V reference voltage -- use if AVDD >= 3.3V */

//#define SAVE_VOLUME /**< Save volume setting to EEPROM */
//#define SAVE_POSITION /**< Save playing song to EEPROM */

//#define PLAYTIME 15 /*play only this number of seconds (15) of each file*/
//#define WAIT_FOR_BUTTON /*Wait for a button after poweron or watchdog reset*/
//#define LOUDNESS_ALWAYS_ON_OFF /*No loudness toggle, use whatever is default*/
//#define NOCHECKFILETYPE /*Do not check filename suffix. */

//#define PAUSE_AT_POWERON /* if PAUSE_BEFORE_PLAY at poweron, pause before the first file and change mode to PAUSE_AFTER_PLAY. */

//#define UART_BUFFERED /* Use buffered UART commands instead of SCI-like UART control. */

//#define LOOP_FILES     /* play the same file until file changed */

#define RECORD_FS 48000U //24000 /* The default recording samplerate. */

#define         MMC_GO_IDLE_STATE   0
#define         MMC_SEND_OP_COND   1
#define         MMC_SEND_IF_COND   8
#define         MMC_SEND_CSD   9
#define         MMC_SEND_CID   10
#define MMC_STOP_TRANSMISSION   12
#define         MMC_SEND_STATUS   13
#define         MMC_SET_BLOCKLEN   16
#define         MMC_READ_SINGLE_BLOCK   17
#define         MMC_READ_MULTIPLE_BLOCK   18
#define         MMC_WRITE_BLOCK   24
#define         MMC_PROGRAM_CSD   27
#define         MMC_SET_WRITE_PROT   28
#define         MMC_CLR_WRITE_PROT   29
#define         MMC_SEND_WRITE_PROT   30
#define         MMC_TAG_SECTOR_START   32
#define         MMC_TAG_SECTOR_END   33
#define         MMC_UNTAG_SECTOR   34
#define         MMC_TAG_ERASE_GROUP_START   35
#define         MMC_TAG_ERARE_GROUP_END   36
#define         MMC_UNTAG_ERASE_GROUP   37
#define         MMC_ERASE   38
#define         MMC_READ_OCR     58
#define         MMC_CRC_ON_OFF   59
#define         MMC_R1_BUSY   0x80
#define         MMC_R1_PARAMETER   0x40
#define         MMC_R1_ADDRESS   0x20
#define         MMC_R1_ERASE_SEQ   0x10
#define         MMC_R1_COM_CRC   0x08
#define         MMC_R1_ILLEGAL_COM   0x04
#define         MMC_R1_ERASE_RESET   0x02
#define         MMC_R1_IDLE_STATE   0x01
#define         MMC_STARTBLOCK_READ   0xFE
#define         MMC_STARTBLOCK_WRITE   0xFE
#define         MMC_STARTBLOCK_MWRITE   0xFC
#define         MMC_STOPTRAN_WRITE   0xFD
#define         MMC_DE_MASK   0x1F
#define         MMC_DE_ERROR   0x01
#define         MMC_DE_CC_ERROR   0x02
#define         MMC_DE_ECC_FAIL   0x04
#define         MMC_DE_OUT_OF_RANGE   0x04
#define         MMC_DE_CARD_LOCKED   0x04
#define         MMC_DR_MASK   0x1F
#define         MMC_DR_ACCEPT   0x05
#define         MMC_DR_REJECT_CRC   0x0B
#define         MMC_DR_REJECT_WRITE_ERROR   0x0D

#ifdef ASM
/* asm-only definitions here */


#else/*ASM*/
/* C-only definitions here */

#include <vsmpg.h>
#include <vs1063.h>
#define SCIMB_CANCEL SCIMB_OUT_OF_WAV
#include <common.h>
#include <stream.h>
#include <layers.h>
#include <asmfuncs.h>
#include <parametric.h>
#include <vstypes.h>

#ifdef RECORDER
#include <encoders.h>
#endif

auto s_int16 myrand(void); /* output 0..0x3fff */
extern __y s_int16 rand_seed;

#include "fat.h"

extern s_int16 hcShift;

void SpiLoad(register __i2 short startAddr);

void MyReset();

auto void SpiSendClocks(void);
auto u_int16 SpiSendReceiveMmc(register __a0 u_int16 topAlignedData,
			       register __a1 numBits);
auto u_int16 MmcCommand(register __b0 s_int16 cmd, register __d u_int32 arg);
auto void ReadDiskSectorTo(register __a u_int32 sector,
			   register __i2 u_int16 *buf);
auto void WritePhysicalSectorY(register __d u_int32 address,
			      register __i3 __y u_int16 *dataBufPtr);
auto u_int16 GetByte(register __c0 u_int16 n);
auto u_int16 GetWord(register __c0 u_int16 n);
auto u_int32 GetLong(register __c0 u_int16 n);
auto u_int16 InitFileSystem(void);
auto __y struct FRAGMENT *FragmentList(register __i2 __y struct FRAGMENT *frag,
			  register __b u_int32 fatCluster);
auto s_int16 HandleDir(register __i2 __y struct FRAGMENT *curFragment,
		       __y struct FRAGMENT *nextFragment);
auto s_int16 OpenFile(register __c0 u_int16 fileNum);
auto s_int16 CheckFileType(register __a u_int32 name);
auto s_int16 CheckFileType1063(register __a u_int32 name);

u_int16 SciModeOr(void);

extern u_int16 created[3]; /*create date, time, 100ths, defaults to 0 */

int UartFill(void);
int UartGetByte(void);
int UartPeekByte(void);

u_int16 Shuffle(register __c0 u_int16 files, register __c1 u_int16 old);

u_int16 GetI6(void);
void CallEncoders(void); /*patched Encoders()*/


void putch(register __a0 short ch);
void puthex(u_int16 d);
void puthex2(u_int16 d);

#endif/*elseASM*/

#endif/*STANDALONE_H*/
