#ifndef __BOARD_H__
#define __BOARD_H__

#include <gpio.h>

// some hardware-specific defines for Codespot.

#define XDCS_PIN (1 << 11)  /* Opto 1 is at xDCS pin */
#define SI_PIN (1 << 10)    /* Opto 2 is at SI pin */

#define BUTTON_1 (1 << 3) /* Button 1 is at GPIO3 */
#define BUTTON_1_PRESSED GPIO_IS_HIGH(BUTTON_1)
#define CONFIGURE_BUTTON_1 {GPIO_CONFIGURE_AS_INPUT(BUTTON_1);}

#define LED_1   (1 << 7) /* Led 1 is at GPIO7 */
#define RELAY_1 (1 << 6) /* Relay 1 is at GPIO6 */
#define RELAY_2 (1 << 5) /* Relay 2 is at GPIO5 */

#define SET_LED_1_ON GPIO_SET_HIGH(LED_1)
#define SET_LED_1_OFF GPIO_SET_LOW(LED_1)
#define SET_RELAY_1_ON GPIO_SET_HIGH(RELAY_1)
#define SET_RELAY_1_OFF GPIO_SET_LOW(RELAY_1)
#define SET_RELAY_2_ON GPIO_SET_HIGH(RELAY_2)
#define SET_RELAY_2_OFF GPIO_SET_LOW(RELAY_2)

#define CONFIGURE_LED_1 {GPIO_CONFIGURE_AS_OUTPUT(LED_1);}
#define CONFIGURE_RELAY_1 {GPIO_CONFIGURE_AS_OUTPUT(RELAY_1);}
#define CONFIGURE_RELAY_2 {GPIO_CONFIGURE_AS_OUTPUT(RELAY_2);}
#define CONFIGURE_LEDS {GPIO_CONFUGURE_AS_OUTPUT(LED_1);}

#define OPTO_1_ACTIVE GPIO_IS_LOW(SI_PIN)
#define OPTO_2_ACTIVE GPIO_IS_LOW(XDCS_PIN)

#define CONFIGURE_OPTO_1 {} // No need for configuration, SI pin is always input
#define CONFIGURE_OPTO_2 {} // No need for configuration, xDCS pin is always input

#endif // __BOARD_H__
