#ifndef _LOCMOTE_H_
#define _LOCMOTE_H_

/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include <stdint.h>

#define LMC_TEMP_REG    0
#define LMC_STA_REG     1
#define LMC_ENA_REG     2
#define LMC_DIS_REG     3
#define LMC_VOLT_REG    4

#define LMC_IO3V_BIT    0
#define LMC_IO3V_MSK    (1 << LMC_IO3V_BIT)
#define LMC_IO5V_BIT    1
#define LMC_IO5V_MSK    (1 << LMC_IO5V_BIT)
#define LMC_IOOK_BIT    2
#define LMC_IOOK_MSK    (1 << LMC_IOOK_BIT)
#define LMC_US2_BIT     4
#define LMC_US2_MSK     (1 << LMC_US2_BIT)
#define LMC_GPS_BIT     5
#define LMC_GPS_MSK     (1 << LMC_GPS_BIT)
#define LMC_PWR_BIT     6
#define LMC_PWR_MSK     (1 << LMC_PWR_BIT)
#define LMC_KEY_BIT     7
#define LMC_KEY_MSK     (1 << LMC_KEY_BIT)

extern void LocmoteEnable(int on);
extern int LocmoteStatus(void);
extern int LocmoteIoVoltage(void);
extern int LocmoteChipTemperature(void);

extern int LocmoteSetRegister(uint8_t reg, uint8_t flags);
extern int LocmoteGetRegister(uint8_t reg);
extern int LocmoteSetBit(uint8_t bit, int val);
extern int LocmotePower(int on);

extern NUTI2C_SLAVE i2cLocmote;

#endif
