#ifndef _PDU_H_
#define _PDU_H_

/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include <stdint.h>
#include <time.h>

#define TP_MTI_LSB      0
#define TP_MTI_BITS     2

#define TP_MMS_LSB      2
#define TP_MMS_BITS     1

#define TP_RD_LSB       2
#define TP_RD_BITS      1

#define TP_VPF_LSB      3
#define TP_VPF_BITS     2

#define TP_SRI_LSB      5
#define TP_SRI_BITS     1

#define TP_SRR_LSB      5
#define TP_SRR_BITS     1

#define TP_UDHI_LSB     6
#define TP_UDHI_BITS    1

#define TP_RP_LSB       7
#define TP_RP_BITS      1

#define TP_MTI          (((1 << TP_MTI_BITS) - 1) << TP_MTI_LSB)
#define TP_MMS          (((1 << TP_MMS_BITS) - 1) << TP_MMS_LSB)
#define TP_RD           (((1 << TP_RD_BITS) - 1) << TP_RD_LSB)
#define TP_VPF          (((1 << TP_VPF_BITS) - 1) << TP_VPF_LSB)
#define TP_SRI          (((1 << TP_SRI_BITS) - 1) << TP_SRI_LSB)
#define TP_SRR          (((1 << TP_SRR_BITS) - 1) << TP_SRR_LSB)
#define TP_UDHI         (((1 << TP_UDHI_BITS) - 1) << TP_UDHI_LSB)
#define TP_RP           (((1 << TP_RP_BITS) - 1) << TP_RP_LSB)

/*
 * Type of incoming messages.
 */
#define TP_MTI_DELIVER          0
#define TP_MTI_SUBMIT_REPORT    1
#define TP_MTI_STATUS_REPORT    2

/*
 * Type of outgoing messages.
 */
#define TP_MTI_DELIVER_REPORT   0
#define TP_MTI_SUBMIT           1
#define TP_MTI_COMMAND          2

#define TP_VPF_NONE             0
#define TP_VPF_INTEGER          2
#define TP_VPF_OCTET            3

typedef struct _SHORT_MESSAGE SHORT_MESSAGE;

struct _SHORT_MESSAGE {
    uint8_t msg_flags;
    char msg_sc_addr[16];
    char msg_ms_addr[16];
    uint8_t msg_proto;
    uint8_t msg_enc;
    time_t msg_time;
    uint8_t msg_len;
    uint8_t *msg_data;
};

extern char *PduEncMsg(const SHORT_MESSAGE *msg);
extern SHORT_MESSAGE *PduDecMsg(const char *pdu, int to_sc);

extern void PduMsgDump(SHORT_MESSAGE *msg);

#endif
