#ifndef _SERVERWATCH_H_
#define _SERVERWATCH_H_

/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include <sys/types.h>
#include <stdint.h>

/*!
 * \brief Phone number to send SMS alerts.
 *
 * Note, that nowadays many mobile phone providers allow to send SMS
 * to ordinary landline phones without SMS capabilities. In this case
 * the text will be automatically converted to a voice message.
 */
#define SMS_TARGET "555"

/*
 * IP address to send SNMP traps.
 */
//#define TRAP_TARGET "192.168.192.233"

/*
 * Xively data cloud settings.
 */
//#define XIVELY_FEED_ID  55555
//#define XIVELY_API_KEY  "mafjsa5ldkfjj7^sdfkljfsadf"

/*
 * ThingSpeak data cloud settings.
 */
//#define THINGSPEAK_API_KEY  "MAFJSA5LDKFJJ7"

/*!
 * \brief First SMS line in system down alerts.
 */
#define SMS_SUBJECT_NODES_DOWN  "Systemausfall:\n"

/*!
 * \brief First SMS line in system up alerts.
 */
#define SMS_SUBJECT_NODES_UP  "Stoerung behoben:\n"

/*!
 * \brief First SMS line in port down alerts.
 */
#define SMS_SUBJECT_PORTS_DOWN  "Verbindungsausfall:\n"

/*!
 * \brief First SMS line in port up alerts.
 */
#define SMS_SUBJECT_PORTS_UP  "Stoerung behoben:\n"

/*!
 * \brief SMS line to report node up/down alerts.
 */
#define SMS_REPORT_NODE "Rechner %s\n"

/*!
 * \brief SMS line to report port up/down alerts.
 */
#define SMS_REPORT_PORT "Rechner %s Port %u\n"

#define MODEM_UARTDEV   devUsartAvr1
#define MODEM_BAUDRATE  115200
#define MODEM_BUFFSIZE  1024


/*!
 * \brief Maximum number of nodes to monitor.
 *
 * You may reduce this number to save some RAM space. Increasing it beyond
 * 8 will require slight modification of a few functions and variable types.
 */
#define MAX_NODES   8

/*!
 * \brief Maximum number of ports to monitor per node.
 *
 * You may reduce this number to save some RAM space. Increasing it beyond
 * 7 will require non-trivial changes in the code.
 */
#define MAX_PORTS   7

/*!
 * \brief Node configuration and status structure type.
 */
typedef struct _NODE_INFO NODE_INFO;

/*!
 * \brief Node configuration and status structure.
 */
struct _NODE_INFO  {
    /*!
     * \brief Required name of this node.
     *
     * Typically set to the fully qualified domain name.
     */
    const char *n_name;
    /*!
     * \brief Optional IP address of this node.
     *
     * If not set (cleared to zero), then _NODE_INFO::n_name
     * must specify the domain name and the IP is queried from
     * the DNS server.
     */
    uint32_t n_ip;
    /*!
     * \brief Dependency
     *
     * Pointer to a node on which this node depends. Typically this
     * points to a router when we are monitoring nodes outside of
     * our local network.
     */
    NODE_INFO *n_depnode;
    /*!
     * \brief Ping response timeout.
     */
    uint32_t n_icmp_timeout;
    /*!
     * \brief Maximum number of ping retries.
     */
    uint_fast8_t n_icmp_retries;
    /*!
     * \brief Poll interval in milliseconds when node is up.
     *
     * Use a large value for minimal load.
     */
    uint32_t n_up_interval;
    /*!
     * \brief Poll interval in milliseconds when node is down.
     *
     * You may use a smaller value here, which will avoid
     * reporting temporary downs.
     */
    uint32_t n_dn_interval;
    /*!
     * \brief Last down status.
     */
    uint_fast8_t n_last_down;
    /*!
     * \brief Monitored TCP ports.
     */
    uint16_t n_ports[MAX_PORTS];
    /*!
     * \brief Node specific event queue.
     *
     * Used by the ICMP callback.
     */
    HANDLE n_queue;
};

extern NODE_INFO nodes[MAX_NODES];


#endif
