#ifndef _SIMCOM_H_
#define _SIMCOM_H_

/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include <stdio.h>
#include <stdint.h>
#include <time.h>

#include "pducodec.h"

#define SMS_STATE_REC_UNREAD    0
#define SMS_STATE_REC_READ      1
#define SMS_STATE_STO_UNSENT    2
#define SMS_STATE_STO_SENT      3
#define SMS_STATE_ALL           4
#define SMS_STATE_MASK          7
#define SMS_STATE_KEEP          128

extern char *SimCmd(FILE *uart, char *cmd, char *rsp, int siz);
extern int SimCmdOk(FILE *uart, char *cmd, int retries);

extern uint32_t SimSwitchTimeout(FILE *uart, uint32_t tmo);
extern void SimFlush(FILE *uart, uint32_t tmo);

extern int SimMsgTextMode(FILE *uart, int on);

typedef struct _SMS_DIRENTRY SMS_DIRENTRY;

struct _SMS_DIRENTRY {
    int ent_index;
    int ent_status;
    SHORT_MESSAGE *ent_msg;
};

typedef struct _SMS_DIRECTORY SMS_DIRECTORY;

struct _SMS_DIRECTORY {
//    char *dir_entry[32];
//    SHORT_MESSAGE *dir_msg[32];
    int dir_len;
    int dir_last;
    SMS_DIRENTRY dir_ent[32];
};

extern SMS_DIRECTORY *SimMsgListLoad(FILE *uart, int state);
extern void SimMsgListUnload(SMS_DIRECTORY *dir);

extern int SimMsgDelIndex(FILE *uart, int idx);
extern int SimMsgSend(FILE *uart, const char *addr, const char *data);
extern int SimMsgRespond(FILE *uart, SHORT_MESSAGE *msg, const char *data);

#endif
