/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include <stdlib.h>
#include <string.h>

#include "simcom.h"
#include "smsalert.h"

SMS_ALERT *SmsAlertOpen(FILE *stream, const char *addr, const char *subject)
{
    SMS_ALERT *smsa;

    smsa = calloc(1, sizeof(SMS_ALERT));
    if (smsa) {
        smsa->sm_stream = stream;
        smsa->sm_addr = strdup(addr);
        if (subject && *subject) {
            smsa->sm_subj = strdup(subject);
            SmsAlertWriteString(smsa, subject);
            smsa->sm_subj_len = smsa->sm_len;
        }
    }
    return smsa;
}

int SmsAlertFlush(SMS_ALERT *smsa)
{
    int rc = 0;

    if (smsa->sm_len > smsa->sm_subj_len) {
        rc = SimMsgSend(smsa->sm_stream, smsa->sm_addr, smsa->sm_text);
        smsa->sm_len = 0;
        if (smsa->sm_subj) {
            SmsAlertWriteString(smsa, smsa->sm_subj);
        }
    }
    return rc;
}

int SmsAlertWrite(SMS_ALERT *smsa, const void *data, int len)
{
    int rc = 0;

    if (smsa->sm_len + len > 140) {
        rc = SmsAlertFlush(smsa);
    }
    memcpy(&smsa->sm_text[smsa->sm_len], data, len);
    smsa->sm_len += len;

    return rc;
}

int SmsAlertWriteString(SMS_ALERT *smsa, const char *str)
{
    return SmsAlertWrite(smsa, str, strlen(str));
}

int SmsAlertClose(SMS_ALERT *smsa)
{
    int rc;

    rc = SmsAlertFlush(smsa);
    free(smsa->sm_addr);
    free(smsa->sm_subj);
    free(smsa);

    return rc;
}
