/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include <arpa/inet.h>
#include <pro/snmp_session.h>

#include <string.h>
#include <stdio.h>
#include <time.h>

/*!
 * \brief Send SNMP trap.
 */
void SendSnmpTrap(OID subtype, uint32_t dest, uint32_t node, char *msg)
{
    SNMP_SESSION *s;
    SNMP_PDU *pdu;
    OID oid[] = {
        SNMP_OID_ENTERPRISES,
        3444,   /* egnite */
        2,      /* egnite products=1 local=2 experimental=3 */
        6       /* egnite Nut/OS */
    };
    OID var[] = {
        SNMP_OID_ENTERPRISES,
        3444,   /* [6] egnite */
        2,      /* egnite products=1 local=2 experimental=3 */
        6,      /* egnite Nut/OS */
        9999,
        0,      /* [10] */
        0,
        0,
        0
    };
    char *id = "public";

    printf("Send trap to %s...", inet_ntoa(dest));
    s = SnmpSessionOpen(dest, 162, (uint8_t *) id, strlen(id));
    if (s) {
        pdu = SnmpPduCreate(SNMP_MSG_TRAP, oid, sizeof(oid) / sizeof(OID));
        if (pdu) {
            pdu->pdu_trap_type = 6;
            pdu->pdu_specific_type = subtype;
            pdu->pdu_time = time(NULL);

            var[10] = (uint8_t) node;
            var[11] = (uint8_t) (node >> 8);
            var[12] = (uint8_t) (node >> 16);
            var[13] = (uint8_t) (node >> 24);
            if (SnmpPduAddVariable(pdu, var, sizeof(var) / sizeof(OID), ASN_OCTET_STR, (uint8_t *) msg, strlen(msg))) {
                puts("VarAdd failed");
            } else {
                if (SnmpSessionSendPdu(s, pdu)) {
                    puts("PDU send failed");
                } else {
                    puts("OK");
                }
            }
            SnmpPduDestroy(pdu);
        } else {
            puts("PDU creation failed");
        }
        SnmpSessionClose(s);
    } else {
        puts("session creation failed");
    }
}


