/*
 * Copyright (C) 2013 by egnite GmbH
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

#include "serverwatch.h"

#include <sys/socket.h>
#include <pro/tcphost.h>
#include <stdio.h>
#include <string.h>

#include "xively_update.h"

#define XIVELY_SERVER   "api.xively.com"

static char buff[512];

/*!
 * \brief Send update to Xively's data cloud in JSON format.
 *
 * \param feed_id Xively feed identifier for this device.
 * \param api_key Xively API key for this device.
 *
 * \return Currently returns 0 only.
 */
int XivelyUpdate(unsigned long feed_id, const char *api_key)
{
    int rc = 0;
    TCPSOCKET *sock;
    FILE *stream;
    char *feedUri = "/v2/feeds";
    int nidx;

    sock = NutTcpCreateSocket();
    if (sock) {
        stream = TcpHostConnectStream(sock, XIVELY_SERVER, 80, 10000);
        if (stream) {
            sprintf(buff,
                    "{\r\n"
                    "  \"datastreams\":[\r\n"
                    );
            for (nidx = 0; nidx < MAX_NODES && nodes[nidx].n_name; nidx++) {
                if (nidx) {
                    sprintf(buff + strlen(buff), ",\r\n");
                }
                sprintf(buff + strlen(buff),
                    "    { \"id\": \"%s\", \"current_value\": \"%d\" }", nodes[nidx].n_name, nodes[nidx].n_last_down ? 0 : 1
                        );
            }

            sprintf(buff + strlen(buff),
                    "\r\n"
                    "  ]\r\n"
                    "}\r\n"
                    );
            for (;;) {
                char *cp = strchr(buff, '.');
                if (cp) {
                    *cp = '_';
                } else {
                    break;
                }
            }
            fprintf(stream, "PUT %s/%lu.json HTTP/1.1\r\n", feedUri, feed_id);
            fprintf(stream, "User-Agent: Ethernut 2.1\r\n");
            fprintf(stream, "Host: %s\r\n", XIVELY_SERVER);
            fprintf(stream, "Accept: */*\r\n");
            fprintf(stream, "X-ApiKey: %s\r\n", api_key);
            fprintf(stream, "Content-Length: %d\r\n", strlen(buff));
            fprintf(stream, "Content-Type: application/json; charset=utf-8\r\n");
            fputs("Connection: close\r\n", stream);
            fputs("\r\n", stream);
            fprintf(stream, "%s", buff);
            fflush(stream);

            while (fgets(buff, sizeof(buff), stream)) {
                fputs(buff, stdout);
            }
            puts("Disconnected");
            fclose(stream);
        } else {
            puts("Error connecting Xively");
        }

        NutTcpCloseSocket(sock);
    } else {
        puts("Error creating socket");
    }
    return rc;
}
