#ifndef _FAVLIST_H_
#define _FAVLIST_H_

/*
 * Copyright (C) 2006-2007 by egnite Software GmbH. All rights reserved.
 * Copyright (C) 2008 by egnite GmbH. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

/*!
 * \file favlist.h
 * \brief Configuration items.
 *
 * \verbatim
 *
 * $Id$
 *
 * \endverbatim
 */

#include "station.h"

#ifndef MAX_FAVORITES
#if defined (AT91SAM9260_EK) || defined(ELEKTOR_IR1)
#define MAX_FAVORITES     128
#else
#define MAX_FAVORITES     8
#endif
#endif

#define TOP_FAVORITE        0
#define LAST_FAVORITE       1


extern RADIOSTATION favlist[MAX_FAVORITES];

__BEGIN_DECLS
/* Prototypes */

extern int FavListSet(int idx, CONST char *symbol, CONST char * uri);
extern int FavListCopy(int src, int dst);
extern int FavListSearch(int idx, int dir);
extern size_t FavListSize(void);
extern int FavListSave(void);
extern int FavListLoad(void);
extern void FavListResetFactory(void);

__END_DECLS
/* End of prototypes */
#endif
