#ifndef _HTTPSERV_H_
#define _HTTPSERV_H_

/*
 * Copyright (C) 2003-2007 by egnite Software GmbH. All rights reserved.
 * Copyright (C) 2008 by egnite GmbH. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

/*!
 * \file httpserv.h
 * \brief MP3 Player HTTP GUI.
 *
 * \verbatim
 *
 * $Log$
 *
 * \endverbatim
 */

#include "webradio.h"
#include "shoutcast.h"

extern int h_timevalid; 

/* Wether to use PHAT file system. UROM is default. */
//#define USE_PHAT

/* Wether to use date and time functions. */
#define USE_DATE_AND_TIME


/* Number of server threads always running. */
#ifndef HTTPD_MIN_THREADS
#define HTTPD_MIN_THREADS   8
#endif

/* Maximum number of server threads. */
#if defined(USE_DYNAMIC_THREADS) && !defined(HTTPD_MAX_THREADS)
#define HTTPD_MAX_THREADS   16
#endif

/* Server thread stack size. */
#ifndef HTTPD_SERVICE_STACK
#define HTTPD_SERVICE_STACK NUT_THREAD_MAINSTACK
#endif

/* The TCP port we are listening at. */
#ifndef HTTPD_TCP_PORT
#define HTTPD_TCP_PORT      80
#endif

/*
 * Maximum segment size.
 *
 * Choose 536 up to 1460. Note, that segment sizes above 536 may result
 * in fragmented packets, which are not supported by Nut/Net.
 */
#ifndef HTTPD_MAX_SEGSIZE
#define HTTPD_MAX_SEGSIZE   1460
#endif

/* TCP stream buffer size. Rule of thumb: 6 times MSS. */
#ifndef HTTPD_TCP_BUFSIZE
#define HTTPD_TCP_BUFSIZE   8760
#endif

/* Closes keep-alive connections. */
#ifndef HTTPD_TCP_TIMEOUT
#define HTTPD_TCP_TIMEOUT   500
#endif


__BEGIN_DECLS
/* Prototypes */

extern int HttpServerStart(void);

__END_DECLS
/* End of prototypes */
#endif
