#ifndef _USERIF_H_
#define _USERIF_H_

/*
 * Copyright (C) 2003-2007 by egnite Software GmbH. All rights reserved.
 * Copyright (C) 2008 by egnite GmbH. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 *
 */

/*!
 * $Log: display.h,v $
 * Revision 1.1  2003/07/21 17:50:48  haraldkipp
 * First check in
 *
 */

#include "webradio.h"

/*! \name Display Status */
/*@{*/
/*! \brief Initial status, displays program banner. */
#define DIST_NONE       0
/*! \brief Waiting? */
#define DIST_WAIT       1
/*! \brief Waiting for connection. */
#define DIST_CONNECTING 2
/*! \brief Successfully connected to a radio station. */
#define DIST_CONNECTED  3
/*! \brief Buffering MP3 data. */
#define DIST_BUFFER     4
/*! \brief Used? */
#define DIST_TITLE      5
/*! \brief Used? */
#define DIST_STATION    6
/*! \brief Display volume. */
#define DIST_VOLUME     7
/*! \brief Currently selected station is dead. */
#define DIST_DEAD       8
/*! \brief Force display update. */
#define DIST_FORCE      9
/*@}*/

extern int UserIfInit(char *name);
extern void UserIfShowStatus(u_char status);
extern void UserIfShowMessage(u_char row, u_char secs, CONST char *fmt, ...);
extern void UserIfEntry(u_char rs);
extern char * UserIfGetDisplayText(char *buff, size_t siz);

#endif
