#ifndef _UTILS_H_
#define _UTILS_H_

/*
 * Copyright (C) 2006-2007 by egnite Software GmbH. All rights reserved.
 * Copyright (C) 2008 by egnite GmbH. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

/*!
 * \file utils.h
 * \brief Useful utility routines.
 *
 * \verbatim
 *
 * $Log$
 *
 * \endverbatim
 */

#include <sys/socket.h>

typedef struct {
    char *schm_uri;
    char *schm_user;
    char *schm_pass;
    char *schm_host;
    char *schm_port;
    char *schm_path;
    u_short schm_portnum;
} HTTP_SCHEME;

__BEGIN_DECLS
/* Prototypes */

extern int TcpHostConnect(TCPSOCKET * sock, CONST char * rhost, u_short port);
extern FILE *TcpStreamAccept(TCPSOCKET * sock, u_short port, char *mode);

extern int TcpGetBuffer(TCPSOCKET * sock, char * buff, u_int size, u_int *status);
extern int TcpGetLine(TCPSOCKET * sock, char * line, u_short size);
extern int TcpGetTag(TCPSOCKET * sock, char * tag, int size);
extern char * LocateAttributeString(CONST char * tag, CONST char * name);
extern int TcpPutString(TCPSOCKET * sock, char * str);
extern int TcpGetHeaderLines(TCPSOCKET * sock, char ***array);
extern void TcpReleaseHeaderLines(char **array);

extern HTTP_SCHEME *HttpSchemeParse(CONST char *uri);
extern void HttpSchemeRelease(HTTP_SCHEME *schm);

extern void Led0(int on);

__END_DECLS
/* End of prototypes */
#endif
