#ifndef _WEBRADIO_H_
#define _WEBRADIO_H_

/*
 * Copyright (C) 2007 by egnite Software GmbH. All rights reserved.
 * Copyright (C) 2008 by egnite GmbH. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 *
 */

/*!
 * \file webradio.h
 * \brief Webradio global header.
 *
 * \verbatim
 *
 * $Log$
 *
 * \endverbatim
 */

#include "station.h"
#include "receiver.h"

#define MAX_RECEIVERS   4

typedef struct {
    u_char wr_status;       /*!< \brief Current status. */
    int wr_gain;            /*!< \brief Set gain of the output DAC in dB. */
    int wr_cfgupd;          /*!< \brief Configuration update counter. */
    int wr_favupd;          /*!< \brief Favorites list update counter. */
    int wr_reboot;
    u_long wr_pridns;
    u_long wr_secdns;
    STATIONINFO *wr_sip;    /*!< \brief Pointer to the current station info structure. */
    RECEIVERINFO *wr_rip;   /*!< \brief Pointer to the current receiver info structure. */
    RECEIVERINFO *wr_ritab[MAX_RECEIVERS + 1];  /*!< \brief Registered receiver types. */
} WEBRADIO;

extern WEBRADIO webradio;

#endif
