#ifndef _XMLSERV_H_
#define _XMLSERV_H_

/*
 * Copyright (C) 2008 by egnite GmbH. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 */

/*!
 * \file xmlserv.h
 * \brief MP3 Player XML Service.
 *
 * \verbatim
 *
 * $Log$
 *
 * \endverbatim
 */

#include "webradio.h"
#include "shoutcast.h"

extern int h_timevalid; 

/* Wether to use date and time functions. */
#define USE_DATE_AND_TIME

/* Number of report server threads always running. */
#ifndef XMLD_MIN_THREADS
#define XMLD_MIN_THREADS   4
#endif

/* Maximum number of report server threads. */
#if defined(USE_DYNAMIC_THREADS) && !defined(XMLD_MAX_THREADS)
#define XMLD_MAX_THREADS   8
#endif

/* Server thread stack size. */
#ifndef XMLD_SERVICE_STACK
#define XMLD_SERVICE_STACK NUT_THREAD_MAINSTACK
#endif

/* The TCP port we are sending status changes. */
#ifndef XMLD_REPO_TCP_PORT
#define XMLD_REPO_TCP_PORT      2008
#endif

/* The TCP port we are receiving control commands. */
#ifndef XMLD_CMD_TCP_PORT
#define XMLD_CMD_TCP_PORT       2009
#endif

/*
 * Maximum segment size.
 *
 * Choose 536 up to 1460. Note, that segment sizes above 536 may result
 * in fragmented packets, which are not supported by Nut/Net.
 */
#ifndef XMLD_MAX_SEGSIZE
#define XMLD_MAX_SEGSIZE   1460
#endif

/* TCP stream buffer size. Rule of thumb: 6 times MSS. */
#ifndef XMLD_TCP_BUFSIZE
#define XMLD_TCP_BUFSIZE   8760
#endif

/* Closes keep-alive connections. */
#ifndef XMLD_TCP_TIMEOUT
#define XMLD_TCP_TIMEOUT   5000
#endif


__BEGIN_DECLS
/* Prototypes */

extern int XmlServerStart(void);
extern void XmlRefresh(void);

__END_DECLS
/* End of prototypes */
#endif
